******************************************************************************************************************
* STANDARD DISABILITY EMPLOYMENT RESULTS USING SELF-REPORTED DISABILITY
/*			NOTE: the analysis here is very simple.
			Most of the length of this syntax file is either set-up, or creating a nice table. */
******************************************************************************************************************

/* SET-UP
		All of these model syntaxes have a section at the starts that sets the details of the analyses that follow - the idea is that it is easier to change 
		things once, than to have to do find-and-replace throughout a series of syntax files.
		We have filled these in with the variables that we used - but you will need to change this to the variables in your data.
		Obviously you also need to load your data here!
*/
global empvar				"rworknew"				// the binary employment variable (1=working, 0=non-working)
global countryvar			"country"				// the categorical variable for country, with each country denoted by a value
global disvar				"llsiH"					// the binary self-reported general disability variable (1 for has a disability, 0 for does not)
global pweight				"rwtresp2"				// the probability weight used for this survey
global controls				"i.ragey i.rmale" 		// control variables
global outputdir 			"${user}\OneDrive - King's College London\Disability work\ESRC Future Leaders Disability\Phase 1 (Dis Emp Rates) - Intl\ELSA-SHARE-HRS\Outputs"	// the file location to save the output tables to
/* Setting the analysis sample (needs to be done from the outset) 
   - these are the ages and countries used in our analysis - you should set this to whatever you are using. */
keep if (ragey>=50 & ragey<70) 
keep if (year==2015 & inlist(country,19,23,29,34,35)) | ( (year==2013 & !inlist(country,19,23,34,35)) | (country==61 & year==2014) | (country==51 & year==2010) )	
drop if missing(${empvar}, ragey, rmale) | (missing(${disvar}) & !inlist(country,51,61) )
// Final things
svyset [pw=${pweight}], strata(country)		// for some commands, it's easier to use the svy prefix than to set weights with [pweight=${pweight}]


/* THE ANALYSIS
		There are two models here - one for disability prevalence, the other for employment
		After each model, we use 'margins' to get the average marginal effects
		We use 'eststo' to store the results of each model - d=disability, e=employment, M=marginal effects, Mr=contrasts of marginal effects
*/
eststo d_${disvar}		: logit ${disvar}  i.${countryvar} 					$controls [pw=${pweight}]
	eststo dM_${disvar} :		margins i.${countryvar}, 				 at(${controlsmeans}) post
eststo e_${disvar}		: logit ${empvar}  ib(0).${disvar}##i.${countryvar} $controls [pw=${pweight}]
	eststo eM_${disvar}	:		margins i.${disvar}, over(${countryvar}) at(${controlsmeans}) post
	estimates restore e_${disvar}
	eststo eMr_${disvar}:		margins r.${disvar}@${countryvar}, 		 at(${controlsmeans}) post
	

/* THE RESULTS TABLE
		Producing nice tables in Stata is tricky. This is one way of producing 
		The first step is to rename the variables so that they simply show the name of the country.
		(As you will see in the full replication file (5_nonbootstrap.do), this also enables us to match different models in the same row).
		We then use the ESTTAB command to produce the tables - all of these options can be tweaked as needed.
*/
// Renaming the coefficients to simply have the country name in them
levelsof ${countryvar}
foreach country in `r(levels)'	{
	local countrylab: label (${countryvar}) `country'
	local countrylab = subinstr("`countrylab'", " ", "_", .)		// estttab, rename() doesn't work with spaces, so need to remove this, and use the 'varlabels' option to insert the space back in
	local rename_eMr `"`rename_eMr' r1vs0.${disvar}@`country'.${countryvar} "`countrylab'" "'
	local rename_eM  `"`rename_eM' `country'.${countryvar}#1.${disvar} "`countrylab'" "'
	local rename_dM  `"`rename_dM' `country'.${countryvar} "`countrylab'" "'
/**/							}
// The output options for all three tables
global esttabopts `"nostar b(%3.1f) ci(%3.1f) transform(@*100 100) varwidth(20) modelwidth(8 15)"'
global esttabopts `"${esttabopts} coeflabels(`labels') nonum replace nolegend nobaselevels wide mtitles(LLSI)"'
global esttabopts `"${esttabopts} addnotes("Table created on `c(current_date)'")"'
// Finally, generating the results tables themselves
esttab eMr_* using "${outputdir}\selfreported_empR.rtf", ${esttabopts} rename(`rename_eMr') title("Disability employment gap")
esttab eM_*  using "${outputdir}\selfreported_empM.rtf", ${esttabopts} rename(`rename_eM' ) title("Disability employment rate") drop(*0.${disvar}*)
esttab dM_*  using "${outputdir}\selfreported_disR.rtf", ${esttabopts} rename(`rename_dM' ) title("Disability rate")
